<x-app-layout>
    <x-slot name="header">
        Role
    </x-slot>

    <div class="row row-sm">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <a href="{{ route('admin.role.create') }}" class="btn btn-primary">Add New</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="datatable" class="table table-bordered text-nowrap border-bottom">
                            <thead>
                                <tr>
                                    <th class="border-bottom-0">Role</th>
                                    <th class="border-bottom-0">Permission</th>
                                    <th class="border-bottom-0">Status</th>
                                    <th class="border-bottom-0">created At</th>
                                    <th class="border-bottom-0">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($roles as $role)
                                <tr>
                                    <td>{{ $role->name }}</td>
                                    <td>{{ $role->permissions_count }}</td>
                                    <td>
                                        @if ($role->status == 1)
                                        <span class="badge bg-success">Active</span>
                                        @else
                                        <span class="badge bg-danger">Inactive</span>
                                        @endif
                                    </td>
                                    <td>{{ $role->created_at->format('d M Y') }}</td>
                                    <td>
                                        <a href="{{ route('admin.role.edit', $role->id) }}"
                                            class="btn btn-primary btn-sm">Permissions</a>
                                        @if ($role->removable)
                                        <a href="javascript:void(0)" data-url="{{ route('admin.destination.destroy', $role->id) }}" class="btn btn-danger confirm-me btn-sm">Delete</a>
                                        @endif
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <x-slot name="script">
        <x-datatable-js />
        <x-confirm-js />
    </x-slot>
</x-app-layout>
